dirs = uigetfile_n_dir;

clear bulkperms;
bulkperms = struct( 'modelname', [], 'permeability', [], 'mass_balance_error', []);
counter = 1;

for idxaam =   3: length( dirs),
    if exist( dirs{idxaam} ) == 7,
       cd( dirs{idxaam} );
       try 
          mf_bulkperm; 
          bulkperms(counter).modelname = dirs{idxaam};
          bulkperms(counter).permeability = bulkpermeability;
          bulkperms(counter).mass_balance_error = mass_balance_error;
          counter = counter + 1;
          close all;
       catch
           bulkperms(counter).modelname = [ 'ERROR!  ', dirs{idxaam} ];
           bulkperms(counter).permeability = nan;
           bulkperms(counter).mass_balance_error = nan;
       end
       cd ..;
    end
end

M = [ {bulkperms.modelname}'  {bulkperms.permeability}' {bulkperms.mass_balance_error}' ];
xlswrite( [ 'bulkpermeabilities ', datestr(now, 'yyyy_mm_dd HH_MM_SS')] , M);
